import { NgModule, ModuleWithProviders } from '@angular/core';
import { CommonModule } from '@angular/common';
import { MccfCommonModule } from '../mccf-common/mccf-common.module'
import { routing } from './mccf-epayment.routing';
import { LockboxComponent } from './lockbox/lockbox.component';
import { EpaymentHomeComponent } from './epayment-home/epayment-home.component';

@NgModule({
  imports: [CommonModule, routing, MccfCommonModule],
  declarations: [LockboxComponent, EpaymentHomeComponent],
  exports: [EpaymentHomeComponent]
})
export class MccfEpaymentModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: EpaymentHomeComponent
    }
  }
}
